<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visits Log | Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/book/assets/css/admin.css">
    <style>
        .pagination {
            display: flex;
            gap: 0.5rem;
            justify-content: flex-end;
            margin-top: 1rem;
        }

        .pagination a {
            padding: 0.5rem 0.75rem;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            color: #64748b;
            text-decoration: none;
        }

        .pagination a.active {
            background: #2563eb;
            color: white;
            border-color: #2563eb;
        }
    </style>
</head>

<body>

    <aside class="admin-sidebar">
        <div class="sidebar-header">Book Admin</div>
        <nav class="sidebar-nav">
            <a href="admin.php?action=dashboard" class="nav-item">📊 Dashboard</a>
            <a href="admin.php?action=registrations" class="nav-item">👥 Registrations</a>
            <a href="admin.php?action=visits" class="nav-item active">👁 Visits Log</a>
        </nav>
        <div class="sidebar-footer">
            <a href="admin.php?action=logout"
                style="color: #ef4444; text-decoration: none; font-size: 0.9rem;">← Logout</a>
        </div>
    </aside>

    <main class="admin-main">
        <header class="main-header">
            <h1 class="page-title">Visits Log</h1>
        </header>

        <!-- Filters -->
        <form method="GET" class="filter-bar">
            <input type="text" name="source" class="form-control" placeholder="Source (utm_source)..."
                value="<?= htmlspecialchars($_GET['source'] ?? '') ?>">
            <button type="submit" class="btn-primary">Filter</button>
            <a href="visits" style="color: #64748b; text-decoration: none; font-size: 0.9rem;">Reset</a>
        </form>

        <div class="table-card">
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>IP Address</th>
                        <th>Source / Medium</th>
                        <th>Page</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($visits)): ?>
                        <tr>
                            <td colspan="4" style="text-align:center; color: var(--text-muted); padding: 2rem;">No visits
                                found.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($visits as $visit): ?>
                            <tr>
                                <td><?= date('Y-m-d H:i', strtotime($visit['created_at'])) ?></td>
                                <td>
                                    <code
                                        style="font-size:0.8rem; background:#f1f5f9; padding:2px 4px; border-radius:4px;"><?= htmlspecialchars($visit['ip_address']) ?></code>
                                </td>
                                <td>
                                    <div>
                                        <span style="font-weight: 500;">Src:</span>
                                        <?= htmlspecialchars($visit['utm_source'] ?? '-') ?>
                                    </div>
                                    <div style="font-size: 0.8rem; color: var(--text-muted);">
                                        Med: <?= htmlspecialchars($visit['utm_medium'] ?? '-') ?>
                                    </div>
                                </td>
                                <td style="font-size: 0.85rem; color: var(--text-muted);">
                                    <?= htmlspecialchars($visit['page_url']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_pages > 1): ?>
            <div class="pagination">
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <a href="?page=<?= $i ?>&source=<?= htmlspecialchars($_GET['source'] ?? '') ?>"
                        class="<?= $page == $i ? 'active' : '' ?>"><?= $i ?></a>
                <?php endfor; ?>
            </div>
        <?php endif; ?>

    </main>
</body>

</html>