<?php
// Simple Router
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$basePath = '/book'; // Assuming hosted at /book

// Debug logging
error_log("DEBUG: Original URI: " . $uri);
error_log("DEBUG: Request Method: " . $_SERVER['REQUEST_METHOD']);

// Remove base path from URI
if (strpos($uri, $basePath) === 0) {
    $uri = substr($uri, strlen($basePath));
}

error_log("DEBUG: URI after strip: " . $uri);

// Handle index.php in URL (e.g. /book/index.php/admin/login)
if (strpos($uri, '/index.php') === 0) {
    $uri = substr($uri, strlen('/index.php'));
}

// Routes
if ($uri === '/' || $uri === '/index.php' || $uri === '') {
    error_log("DEBUG: Loading landing page");
    require __DIR__ . '/views/landing.php';
} elseif ($uri === '/submit') {
    error_log("DEBUG: Loading submit route");
    require_once __DIR__ . '/src/LeadController.php';
    (new LeadController())->submit();
} elseif ($uri === '/download') {
    require_once __DIR__ . '/src/LeadController.php';
    (new LeadController())->download();
} elseif (strpos($uri, '/admin') === 0) {
    require_once __DIR__ . '/src/AdminController.php';
    $admin = new AdminController();

    if ($uri === '/admin/login') {
        $admin->login();
    } elseif ($uri === '/admin/logout') {
        $admin->logout();
    } elseif ($uri === '/admin/registrations') {
        $admin->registrations();
    } elseif ($uri === '/admin/visits') {
        $admin->visits();
    } elseif ($uri === '/admin/export') {
        $admin->export_csv();
    } else {
        // This else block now handles the dashboard and 404 for admin routes
        if ($uri === '/admin' || $uri === '/admin/') {
            $admin->dashboard();
        } else {
            http_response_code(404);
            echo "Admin Route Not Found";
        }
    }
} elseif ($uri === '/terms') {
    require __DIR__ . '/views/legal/terms.php';
} elseif ($uri === '/privacy') {
    require __DIR__ . '/views/legal/privacy.php';
} else {
    // 404
    error_log("DEBUG: 404 - URI not found: " . $uri);
    http_response_code(404);
    echo "404 Not Found";
}
